document.onkeydown = function () {backSpace();}
function backSpace() {
	if(window.event.keyCode != 8) {
		return true;
	}
	if (window.event.srcElement.nodeName != "INPUT") {
  	window.event.keyCode = 0;
    return false;	
	}
	return true;
}
function base64encode(str) {
	var out, i, len;
	var c1, c2, c3;
	
	var base64EncodeChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
	
	len = str.length;
	i = 0;
	out = "";
	while(i < len) {
		c1 = str.charCodeAt(i++) & 0xff;
 		if(i == len) {
			out += base64EncodeChars.charAt(c1 >> 2);
		  out += base64EncodeChars.charAt((c1 & 0x3) << 4);
		  out += "==";
		  break;
		}
	 	c2 = str.charCodeAt(i++);
	 	if(i == len) {
			out += base64EncodeChars.charAt(c1 >> 2);
			out += base64EncodeChars.charAt(((c1 & 0x3)<< 4) | ((c2 & 0xF0) >> 4));
			out += base64EncodeChars.charAt((c2 & 0xF) << 2);
			out += "=";
			break;
		}
		c3 = str.charCodeAt(i++);
		out += base64EncodeChars.charAt(c1 >> 2);
		out += base64EncodeChars.charAt(((c1 & 0x3)<< 4) | ((c2 & 0xF0) >> 4));
		out += base64EncodeChars.charAt(((c2 & 0xF) << 2) | ((c3 & 0xC0) >>6));
		out += base64EncodeChars.charAt(c3 & 0x3F);
	}
  return out;
}
function utf16to8(str) {
	var out, i, len, c;
	
	out = "";
	len = str.length;
	for(i = 0; i < len; i++) {
		c = str.charCodeAt(i);
 		if ((c >= 0x0001) && (c <= 0x007F)) {
    	out += str.charAt(i);
 		} else if (c > 0x07FF) {
    	out += String.fromCharCode(0xE0 | ((c >> 12) & 0x0F));
			out += String.fromCharCode(0x80 | ((c >>  6) & 0x3F));
			out += String.fromCharCode(0x80 | ((c >>  0) & 0x3F));
		} else {
			out += String.fromCharCode(0xC0 | ((c >>  6) & 0x1F));
			out += String.fromCharCode(0x80 | ((c >>  0) & 0x3F));
		}
	}
  return out;
}

function trim(str){  
	return str.replace(/(^\s*)|(\s*$)/g, "");
}


function UrlEncode(str) { 
	var ret=""; 
	try {
		ret = UrlEncode2(str);
	} catch(err) {
		ret = window.external.getUrlEncode(str);		
	}
	return ret;
}

function UrlEncode2(str) { 
	var ret=""; 
	var strSpecial="!\"#$%&'()*+,/:;<=>?[]^`{|}~%"; 
	for(var i=0;i<str.length;i++) { 
		var chr = str.charAt(i); 
		var c=str2asc(chr); 
    if(parseInt("0x"+c) > 0x7f){ 
			ret+="%"+c.slice(0,2)+"%"+c.slice(-2); 
    }else{ 
      if(chr==" ") 
        ret+="+"; 
      else if(strSpecial.indexOf(chr)!=-1) 
        ret+="%"+c.toString(16); 
      else 
        ret+=chr; 
    } 
  } 
  return ret;
}
function isEnabledObj(obj) {
	if (obj.skiped == "1") {
		return false;
	}
	if (obj.type == "checkbox") {
		return obj.checked;
	}

	if (obj.type == "radio") {
		return obj.checked;
	}	
	return true;
}

function getDivArray(doc, path) {
  var array = new Array();
  var nodes = doc.selectSingleNode(path).childNodes;
  for( var j=0; j<nodes.length; j++ ) {
    var node=nodes[j];
  	var value = node.getAttribute('name') + "|" + node.getAttribute('value');
    array.push(value);
  }
  return array;
}

function initDivInfo(div1Id, div2Id, xml) {
	var xmldoc=new ActiveXObject("MSXML2.DOMDocument");
	xmldoc.async=false;
	xmldoc.load(xml);
	
	var pDiv1 =  document.getElementById(div1Id);
	for(var i = pDiv1.options.length-1; i >= 0; i--) {
       pDiv1.options[i] = null;
	}
	
	var array = getDivArray(xmldoc, "/div");
	for(var i=0; i<array.length; i++) {
		var infoArray = new Array();
		infoArray = array[i].split("|");
		pDiv1.options[i] = new Option(infoArray[0], infoArray[1]);
	}
	pDiv1.options[0].selected = true;
	changeDiv1(div1Id, div2Id, xmldoc);
	pDiv1.onchange = function(){changeDiv1(div1Id, div2Id, xmldoc)};
}

function changeDiv1(div1Id, div2Id, xmldoc) {
	var pDiv2 = document.getElementById(div2Id);
	
	for (var i = pDiv2.options.length-1; i>=0; i--) {
       pDiv2.options[i] = null;
	}
	var pDiv1 = document.getElementById(div1Id);
	var array = getDivArray(xmldoc,"/div/div1[@value='"+pDiv1.value+"']");
	
	pDiv2.options[0] = new Option("ȫѡ",pDiv1.value);
	for (var i = 0; i<array.length; i++ ) {
		var infoArray = new Array();
		infoArray = array[i].split("|");
    pDiv2.options[i+1] = new Option(infoArray[0], infoArray[1]);
	}
	if (!pDiv2.options[0].selected) {
		pDiv2.options[0].selected = true;
	}
}

function replaceText(OrgStr, Target, Change) {
	var index, len=0;
	var fullStr = '';

	while ( (index=OrgStr.indexOf(Target)) >= 0) {
		fullStr = fullStr + ''+ OrgStr.substring(0,index) + ''+Change ;
		OrgStr = OrgStr.substring(index+Target.length);
	}
	return fullStr+''+OrgStr;
}

function getCookieVal (offset) {
  var endstr = document.cookie.indexOf (";", offset);
  if (endstr == -1)
    endstr = document.cookie.length;
  return unescape(document.cookie.substring(offset, endstr));
}

function GetCookie (name) {
  var arg = name + "=";
  var alen = arg.length;
  var clen = document.cookie.length;
  var i = 0;
  while (i < clen) {
    var j = i + alen;
    if (document.cookie.substring(i, j) == arg)
      return getCookieVal (j);
    i = document.cookie.indexOf(" ", i) + 1;
    if (i == 0) break;
  }
  return null;
}

function SetCookie (name,value,expires,path,domain,secure) {
  document.cookie = name + "=" + escape (value) +
    ((expires) ? "; expires=" + expires.toGMTString() : "") +
    ((path) ? "; path=" + path : "") +
    ((domain) ? "; domain=" + domain : "") +
    ((secure) ? "; secure" : "");
}

function initNewDivInfo(div1Id, div2Id, xml) {
	var xmldoc=new ActiveXObject("MSXML2.DOMDocument");
	xmldoc.async=false;
	xmldoc.load(xml);
	
	var pDiv1 =  document.getElementById(div1Id);
	for(var i = pDiv1.options.length-1; i >= 0; i--) {
       pDiv1.options[i] = null;
	}
	
	var array = getDivArray(xmldoc, "/div");
	for(var i=0; i<array.length; i++) {
		var infoArray = new Array();
		infoArray = array[i].split("|");
		var selValue = "";
		if (infoArray[1] != 'null') {
			selValue = infoArray[1];
		}
		pDiv1.options[i] = new Option(infoArray[0], selValue);
	}
	pDiv1.options[0].selected = true;
	changeNewDiv1(div1Id, div2Id, xmldoc);
	pDiv1.onchange = function(){changeNewDiv1(div1Id, div2Id, xmldoc)};
}

function changeNewDiv1(div1Id, div2Id, xmldoc) {
	var pDiv2 = document.getElementById(div2Id);
	
	for (var i = pDiv2.options.length-1; i>=0; i--) {
       pDiv2.options[i] = null;
	}
	var pDiv1 = document.getElementById(div1Id);
	var pDiv1Value = pDiv1.options[pDiv1.options.selectedIndex].innerText;
	var array = getDivArray(xmldoc,"/div/div1[@name='"+pDiv1Value+"']");
	var i = -1
	for (i = 0; i<array.length; i++ ) {
		var infoArray = new Array();
		infoArray = array[i].split("|");
    pDiv2.options[i] = new Option(infoArray[0], infoArray[1]);
	}
	if (i >= 0) {
		if (!pDiv2.options[0].selected) {
			pDiv2.options[0].selected = true;
		}
	}
}